<?php
namespace Agent3w\Af2a\Inc;

if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Agent3w\Af2a\Inc\Plugins\Wapf_Addon;

class Agent3w_Af2a
{
    public static $_plugin_dir;
    public static $_plugin_dir_url;
    public static $_wapf;

    public function __construct( array $constantes )
    {
        if ( array_key_exists( 'plugin_dir', $constantes ) ) { self::$_plugin_dir = $constantes['plugin_dir']; }
        if ( array_key_exists( 'plugin_dir_url', $constantes ) ) { self::$_plugin_dir_url = $constantes['plugin_dir_url']; }
        return $this;
    }

    public function run()
    {
        add_action('plugins_loaded', [ $this, 'init' ]);
        return $this;
    }
    
    /**
     * init
     * Fonction d'initialisation du plugin
     *
     * @return Agent3w_Af2a
     */
    public function init()
    {
        // Active les fonctionnalités liées à la surchage du plugin Advanced Product Fields Pro for WooCommerce
        if ( is_plugin_active( 'advanced-product-fields-for-woocommerce-pro/advanced-product-fields-for-woocommerce-pro.php' ) ) {
            if ( defined('AF2A_OPTION_ADDON_WAPF') && AF2A_OPTION_ADDON_WAPF ) {
                self::$_wapf = new Wapf_Addon();
                self::$_wapf->init();
            }
        }

        // Override des templates woocommerce dans le plugin
        if ( defined('AF2A_OPTION_WC_OVERRIDE_TEMPLATES') && AF2A_OPTION_WC_OVERRIDE_TEMPLATES ) {
            add_filter( 'woocommerce_locate_template', [ $this, 'wc_plugin_template' ], 1, 3 );
        }

        // Filtrer les formations dans le panier
        if ( defined('AF2A_OPTION_WC_TRIER_LES_COMMANDES') && AF2A_OPTION_WC_TRIER_LES_COMMANDES ) {
            add_action( 'woocommerce_before_cart_contents', [ $this, 'sort_cart_items' ] );
            add_action( 'woocommerce_cart_loaded_from_session', [ $this, 'sort_cart_items' ] );
        }

        return $this;
    }
    
    /**
     * wc_plugin_template
     * Écrase les templates woocommerce par ceux contenus dans le dossier templates/woocommerce du plugin
     *
     * @param  string $template
     * @param  string $template_name
     * @param  string $template_path
     * @return string $template
     */
    public function wc_plugin_template( $template, $template_name, $template_path ) {
        global $woocommerce;
        $_template = $template;

        if ( ! $template_path )  {
            $template_path = $woocommerce->template_url;
        }
        
        $plugin_path  = untrailingslashit( self::$_plugin_dir )  . '/templates/woocommerce/';
        
        // Look within passed path within the theme - this is priority
        $template = locate_template(
            array(
                $template_path . $template_name,
                $template_name
            )
        );
        
        if( ! $template && file_exists( $plugin_path . $template_name ) ) {
            $template = $plugin_path . $template_name;
        }
        
        if ( ! $template ) {
            $template = $_template;
        }
    
        return $template;
    }

    
    /**
     * sort_cart_items
     * Trie les produits dans les résumés de commande en séparant les payant et les non payants
     * L'ordre est défini par une option
     * Le trie est visible dans :
     * - la page panier
     * - la page de paiement
     * - la page de confirmation
     *
     * @return void
     */
    public function sort_cart_items()
    {
        $cart = WC()->cart;

        //if the cart is empty do nothing
        if ( empty( $cart ) || empty( $cart->cart_contents ) ) {
            return;
        }

        $precommandes = [];
        $commandes = [];

        foreach ( $cart->cart_contents as $cart_item_key => $cart_item ) {
            if ( $cart_item['data']->get_price() == 0 ) {
                $precommandes[ $cart_item_key ] = $cart_item;
            } else {
                $commandes[ $cart_item_key ] = $cart_item;
            }
        }

        global $woocommerce;
        if ( defined('AF2A_OPTION_WC_PRECO_AVANT_PAYANT') && AF2A_OPTION_WC_PRECO_AVANT_PAYANT ) {
            $woocommerce->cart->cart_contents = $precommandes + $commandes;
        } else {
            $woocommerce->cart->cart_contents = $commandes + $precommandes;
        }
    }
}
