<?php

namespace Saltus\WP\Plugin\Saltus\InteractiveMaps\Plugin\Pro;

use Saltus\WP\Plugin\Saltus\InteractiveMaps\Core;

/**
 * Manage available vector icons
 */
class ProIcons {

	/**
	 * Available icons
	 */
	public $icons;

	/**
	 * Define Icons
	 *
	 * @param Core $core This plugin's instance.
	 */
	public function __construct() {

		$this->icons = $this->get_icons();

		// filters - set custom icons for fields
		add_filter( 'csf_field_icon_add_icons', array( $this, 'custom_icons' ) );

	}

	/**
	 * Set available icons
	 *
	 * @return void
	 */
	public function get_icons() {

		$icons = [
			'fa fa-star'                   => [
				/* translators: word to identify a vector icon */
				'title' => _x( 'Star', 'Icon Description', 'interactive-geo-maps' ),
				'path'  => 'M9 9l-5 1v1l4 3a2286 2286 0 0 0-1 6l5-3a14908 14908 0 0 0 5 2l-1-5 4-3v-1l-5-1-3-5-3 5z',
			],
			'fa fa-home'                   => [
				/* translators: word to identify a vector icon */
				'title' => _x( 'Home', 'Icon Description', 'interactive-geo-maps' ),
				'path'  => 'm9.876375,6.192397l-6.175384,5.086142l0,5.489416a0.535912,0.535912 0 0 0 0.535912,0.535912l3.753395,-0.009713a0.535912,0.535912 0 0 0 0.533233,-0.535912l0,-3.20576a0.535912,0.535912 0 0 1 0.535912,-0.535912l2.143649,0a0.535912,0.535912 0 0 1 0.535912,0.535912l0,3.203415a0.535912,0.535912 0 0 0 0.535912,0.537587l3.752056,0.010383a0.535912,0.535912 0 0 0 0.535912,-0.535912l0,-5.4931l-6.174044,-5.082458a0.408298,0.408298 0 0 0 -0.512466,0zm9.754608,3.456969l-2.800141,-2.308107l0,-4.639325a0.401934,0.401934 0 0 0 -0.401934,-0.401934l-1.875693,0a0.401934,0.401934 0 0 0 -0.401934,0.401934l0,2.432037l-2.998764,-2.467206a1.607737,1.607737 0 0 0 -2.043165,0l-8.478466,6.982601a0.401934,0.401934 0 0 0 -0.053591,0.566057l0.85411,1.03833a0.401934,0.401934 0 0 0 0.566392,0.054596l7.87858,-6.489227a0.408298,0.408298 0 0 1 0.512466,0l7.878915,6.489227a0.401934,0.401934 0 0 0 0.566057,-0.053591l0.85411,-1.03833a0.401934,0.401934 0 0 0 -0.056941,-0.567062z',
			],
			'fa fa-anchor'                 => [
				/* translators: word to identify a vector icon which is an anchor */
				'title' => _x( 'Anchor', 'Icon Description', 'interactive-geo-maps' ),
				'path'  => 'm10.529546,3.057879q0,-0.285175 -0.208397,-0.493572t-0.493572,-0.208397t-0.493572,0.208397t-0.208397,0.493572t0.208397,0.493572t0.493572,0.208397t0.493572,-0.208397t0.208397,-0.493572zm9.125606,10.178561l0,3.860833q0,0.241302 -0.219366,0.329048q-0.087746,0.021937 -0.131619,0.021937q-0.131619,0 -0.25227,-0.098714l-1.02005,-1.02005q-1.305225,1.568464 -3.493396,2.484315t-4.710875,0.915851t-4.710875,-0.915851t-3.493396,-2.484315l-1.02005,1.02005q-0.098714,0.098714 -0.25227,0.098714q-0.043873,0 -0.131619,-0.021937q-0.219366,-0.087746 -0.219366,-0.329048l0,-3.860833q0,-0.153556 0.098714,-0.25227t0.25227,-0.098714l3.860833,0q0.241302,0 0.329048,0.219366q0.087746,0.208397 -0.076778,0.38389l-1.096828,1.096828q0.734875,0.998113 2.078488,1.68363t2.977887,0.904883l0,-7.096475l-2.105909,0q-0.285175,0 -0.493572,-0.208397t-0.208397,-0.493572l0,-1.403939q0,-0.285175 0.208397,-0.493572t0.493572,-0.208397l2.105909,0l0,-1.787829q-0.63616,-0.372921 -1.02005,-1.014566t-0.38389,-1.409424q0,-1.162637 0.822621,-1.985258t1.985258,-0.822621t1.985258,0.822621t0.822621,1.985258q0,0.767779 -0.38389,1.409424t-1.02005,1.014566l0,1.787829l2.105909,0q0.285175,0 0.493572,0.208397t0.208397,0.493572l0,1.403939q0,0.285175 -0.208397,0.493572t-0.493572,0.208397l-2.105909,0l0,7.096475q1.634273,-0.219366 2.977887,-0.904883t2.078488,-1.68363l-1.096828,-1.096828q-0.164524,-0.175492 -0.076778,-0.38389q0.087746,-0.219366 0.329048,-0.219366l3.860833,0q0.153556,0 0.25227,0.098714t0.098714,0.25227z',
			],
			'fa fa-arrow-circle-o-down'    => [
				/* translators: word to identify a vector icon */
				'title' => _x( 'Circle Arrow Down', 'Icon Description', 'interactive-geo-maps' ),
				'path'  => 'm10,0.4c-5.082258,0 -9.199999,4.117742 -9.199999,9.199999s4.117742,9.199999 9.199999,9.199999s9.199999,-4.117742 9.199999,-9.199999s-4.117742,-9.199999 -9.199999,-9.199999zm0,16.619354c-4.099193,0 -7.419354,-3.320161 -7.419354,-7.419354s3.320161,-7.419354 7.419354,-7.419354s7.419354,3.320161 7.419354,7.419354s-3.320161,7.419354 -7.419354,7.419354zm-1.187097,-11.72258l0,4.303225l-2.485484,0c-0.396935,0 -0.593548,0.478548 -0.315323,0.760484l3.67258,3.67258c0.174355,0.174355 0.45629,0.174355 0.630645,0l3.67258,-3.67258c0.281935,-0.281935 0.081613,-0.760484 -0.315323,-0.760484l-2.485484,0l0,-4.303225c0,-0.244839 -0.200323,-0.445161 -0.445161,-0.445161l-1.483871,0c-0.244839,0 -0.445161,0.200323 -0.445161,0.445161z',
			],
			'fa fa-map-marker'        => [
				/* translators: word to identify a vector icon */
				'title' => _x( 'Location Marker', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm9.2701,19.39322c-5.60476,-8.12524 -6.64511,-8.95914 -6.64511,-11.94529c0,-4.09038 3.31588,-7.40626 7.40626,-7.40626s7.40626,3.31588 7.40626,7.40626c0,2.98615 -1.04035,3.82005 -6.64511,11.94529c-0.36781,0.53132 -1.15453,0.53128 -1.52229,0zm0.76115,-8.85935c1.70433,0 3.08594,-1.38161 3.08594,-3.08594s-1.38161,-3.08594 -3.08594,-3.08594s-3.08594,1.38161 -3.08594,3.08594s1.38161,3.08594 3.08594,3.08594z',
			],

			'fa fa-dot-circle-o'        => [
				/* translators: word to identify a vector icon with a circle around a dot */
				'title' => _x( 'Circle dot', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm13.32837,10.01452q0,1.37213 -0.97085,2.34298t-2.34298,0.97085t-2.34298,-0.97085t-0.97085,-2.34298t0.97085,-2.34298t2.34298,-0.97085t2.34298,0.97085t0.97085,2.34298zm-3.31383,-7.04188q-1.91581,0 -3.53389,0.94496t-2.56304,2.56304t-0.94496,3.53389t0.94496,3.53389t2.56304,2.56304t3.53389,0.94496t3.53389,-0.94496t2.56304,-2.56304t0.94496,-3.53389t-0.94496,-3.53389t-2.56304,-2.56304t-3.53389,-0.94496zm9.94148,7.04188q0,2.70543 -1.3333,4.99016t-3.61803,3.61803t-4.99016,1.3333t-4.99016,-1.3333t-3.61803,-3.61803t-1.3333,-4.99016t1.3333,-4.99016t3.61803,-3.61803t4.99016,-1.3333t4.99016,1.3333t3.61803,3.61803t1.3333,4.99016z',
			],

			'fa fa-heart'        => [
				/* translators: word to identify a heart shaped vector */
				'title' => _x( 'Heart', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm10.03125,18.54464q-0.28746,0 -0.48647,-0.19901l-6.899,-6.65576q-0.11056,-0.08845 -0.30404,-0.28746t-0.61361,-0.72417t-0.75181,-1.07797t-0.5915,-1.33779t-0.25982,-1.52574q0,-2.43234 1.40412,-3.80329t3.88069,-1.37095q0.68548,0 1.39859,0.23771t1.32673,0.64125t1.05586,0.75734t0.84026,0.75181q0.39802,-0.39802 0.84026,-0.75181t1.05586,-0.75734t1.32673,-0.64125t1.39859,-0.23771q2.47656,0 3.88069,1.37095t1.40412,3.80329q0,2.44339 -2.53184,4.97524l-6.88794,6.63365q-0.19901,0.19901 -0.48647,0.19901z',
			],

			'fa fa-car'        => [
				/* translators: word to identify a car shaped vector */
				'title' => _x( 'Car', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm4.85738,11.52354q0,-0.61634 -0.43891,-1.05524t-1.05524,-0.43891t-1.05524,0.43891t-0.43891,1.05524t0.43891,1.05524t1.05524,0.43891t1.05524,-0.43891t0.43891,-1.05524zm0.33618,-2.9883l9.48785,0l-0.83112,-3.33382q-0.01868,-0.07471 -0.13074,-0.16342t-0.19611,-0.08872l-7.17192,0q-0.08405,0 -0.19611,0.08872t-0.13074,0.16342l-0.83112,3.33382zm12.81233,2.9883q0,-0.61634 -0.43891,-1.05524t-1.05524,-0.43891t-1.05524,0.43891t-0.43891,1.05524t0.43891,1.05524t1.05524,0.43891t1.05524,-0.43891t0.43891,-1.05524zm1.49415,-0.89649l0,3.58596q0,0.13074 -0.08405,0.21478t-0.21478,0.08405l-0.89649,0l0,1.19532q0,0.74707 -0.52295,1.27003t-1.27003,0.52295t-1.27003,-0.52295t-0.52295,-1.27003l0,-1.19532l-9.56256,0l0,1.19532q0,0.74707 -0.52295,1.27003t-1.27003,0.52295t-1.27003,-0.52295t-0.52295,-1.27003l0,-1.19532l-0.89649,0q-0.13074,0 -0.21478,-0.08405t-0.08405,-0.21478l0,-3.58596q0,-0.86847 0.61167,-1.48014t1.48014,-0.61167l0.26148,0l0.98054,-3.9128q0.21478,-0.87781 0.9712,-1.4708t1.67158,-0.59299l7.17192,0q0.91517,0 1.67158,0.59299t0.9712,1.4708l0.98054,3.9128l0.26148,0q0.86847,0 1.48014,0.61167t0.61167,1.48014z',
			],

			'fa fa-bus'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Bus', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm5.875,13.44792q0,-0.56071 -0.39673,-0.95744t-0.95744,-0.39673t-0.95744,0.39673t-0.39673,0.95744t0.39673,0.95744t0.95744,0.39673t0.95744,-0.39673t0.39673,-0.95744zm10.83333,0q0,-0.56071 -0.39673,-0.95744t-0.95744,-0.39673t-0.95744,0.39673t-0.39673,0.95744t0.39673,0.95744t0.95744,0.39673t0.95744,-0.39673t0.39673,-0.95744zm-0.48665,-4.18945l-0.76172,-4.0625q-0.0529,-0.24333 -0.23804,-0.39673t-0.42847,-0.1534l-9.71191,0q-0.24333,0 -0.42847,0.1534t-0.23804,0.39673l-0.76172,4.0625q-0.0529,0.31738 0.14811,0.56071t0.51839,0.24333l11.23535,0q0.31738,0 0.51839,-0.24333t0.14811,-0.56071zm-2.39095,-6.47461q0,-0.21159 -0.14811,-0.3597t-0.3597,-0.14811l-6.77083,0q-0.21159,0 -0.3597,0.14811t-0.14811,0.3597t0.14811,0.3597t0.3597,0.14811l6.77083,0q0.21159,0 0.3597,-0.14811t0.14811,-0.3597zm4.23177,7.67008l0,6.37939l-1.35417,0l0,1.35417q0,0.56071 -0.39673,0.95744t-0.95744,0.39673t-0.95744,-0.39673t-0.39673,-0.95744l0,-1.35417l-8.125,0l0,1.35417q0,0.56071 -0.39673,0.95744t-0.95744,0.39673t-0.95744,-0.39673t-0.39673,-0.95744l0,-1.35417l-1.35417,0l0,-6.37939q0,-1.1849 0.26449,-2.35921l1.08968,-4.80306q0.09521,-0.8252 1.03149,-1.44938t2.43327,-0.94157t3.30607,-0.31738t3.30607,0.31738t2.43327,0.94157t1.03149,1.44938l1.11084,4.80306q0.24333,1.0791 0.24333,2.35921z',
			],

			'fa fa-train'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Train', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm13.43757,0.35413q1.98731,0 3.39992,1.0044t1.4126,2.43312l0,9.62504q0,1.39649 -1.34815,2.38478t-3.28175,1.042l2.2881,2.16993q0.17188,0.16113 0.08594,0.37598t-0.32227,0.21484l-11.3438,0q-0.23633,0 -0.32227,-0.21484t0.08594,-0.37598l2.2881,-2.16993q-1.9336,-0.05371 -3.28175,-1.042t-1.34815,-2.38478l0,-9.62504q0,-1.42872 1.4126,-2.43312t3.39992,-1.0044l6.87503,0zm-3.43752,14.43757q0.85938,0 1.46094,-0.60157t0.60157,-1.46094t-0.60157,-1.46094t-1.46094,-0.60157t-1.46094,0.60157t-0.60157,1.46094t0.60157,1.46094t1.46094,0.60157zm6.18753,-6.18753l0,-5.50003l-12.37506,0l0,5.50003l12.37506,0z',
			],

			'fa fa-times'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Times (Cross)', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm19.31273,15.67551q0,0.62711 -0.43898,1.06608l-2.13217,2.13217q-0.43898,0.43898 -1.06608,0.43898t-1.06608,-0.43898l-4.60925,-4.60925l-4.60925,4.60925q-0.43898,0.43898 -1.06608,0.43898t-1.06608,-0.43898l-2.13217,-2.13217q-0.43898,-0.43898 -0.43898,-1.06608t0.43898,-1.06608l4.60925,-4.60925l-4.60925,-4.60925q-0.43898,-0.43898 -0.43898,-1.06608t0.43898,-1.06608l2.13217,-2.13217q0.43898,-0.43898 1.06608,-0.43898t1.06608,0.43898l4.60925,4.60925l4.60925,-4.60925q0.43898,-0.43898 1.06608,-0.43898t1.06608,0.43898l2.13217,2.13217q0.43898,0.43898 0.43898,1.06608t-0.43898,1.06608l-4.60925,4.60925l4.60925,4.60925q0.43898,0.43898 0.43898,1.06608z',
			],

			'fa fa-check-circle'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Check Circle', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm16.63509,7.91719q0,-0.36003 -0.23145,-0.59148l-1.1701,-1.15724q-0.24431,-0.24431 -0.57862,-0.24431t-0.57862,0.24431l-5.24615,5.23329l-2.90595,-2.90595q-0.24431,-0.24431 -0.57862,-0.24431t-0.57862,0.24431l-1.1701,1.15724q-0.23145,0.23145 -0.23145,0.59148q0,0.34717 0.23145,0.57862l4.65467,4.65467q0.24431,0.24431 0.57862,0.24431q0.34717,0 0.59148,-0.24431l6.98201,-6.98201q0.23145,-0.23145 0.23145,-0.57862zm3.24027,2.08303q0,2.68737 -1.3244,4.95684t-3.59387,3.59387t-4.95684,1.3244t-4.95684,-1.3244t-3.59387,-3.59387t-1.3244,-4.95684t1.3244,-4.95684t3.59387,-3.59387t4.95684,-1.3244t4.95684,1.3244t3.59387,3.59387t1.3244,4.95684z',
			],

			'fa fa-female'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Female Figure', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm17.1875,11.56719q0,0.44727 -0.31309,0.76035t-0.76035,0.31309q-0.57026,0 -0.89453,-0.48081l-2.53823,-3.81294l-0.50317,0l0,1.47598l2.76187,4.59566q0.10063,0.16772 0.10063,0.36899q0,0.29072 -0.21245,0.50317t-0.50317,0.21245l-2.14688,0l0,3.04141q0,0.51436 -0.36899,0.88335t-0.88335,0.36899l-1.78906,0q-0.51436,0 -0.88335,-0.36899t-0.36899,-0.88335l0,-3.04141l-2.14688,0q-0.29072,0 -0.50317,-0.21245t-0.21245,-0.50317q0,-0.20127 0.10063,-0.36899l2.76187,-4.59566l0,-1.47598l-0.50317,0l-2.53823,3.81294q-0.32427,0.48081 -0.89453,0.48081q-0.44727,0 -0.76035,-0.31309t-0.31309,-0.76035q0,-0.32427 0.17891,-0.59263l2.8625,-4.29375q0.81626,-1.19644 1.96797,-1.19644l4.29375,0q1.15171,0 1.96797,1.19644l2.8625,4.29375q0.17891,0.26836 0.17891,0.59263zm-4.65156,-8.94531q0,1.03989 -0.7324,1.77229t-1.77229,0.7324t-1.77229,-0.7324t-0.7324,-1.77229t0.7324,-1.77229t1.77229,-0.7324t1.77229,0.7324t0.7324,1.77229z',
			],

			'fa fa-flag'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Flag', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm3.24303,2.94442q0,0.78906 -0.70139,1.20551l0,13.87437q0,0.14247 -0.10411,0.24658t-0.24658,0.10411l-0.70139,0q-0.14247,0 -0.24658,-0.10411t-0.10411,-0.24658l0,-13.87437q-0.70139,-0.41645 -0.70139,-1.20551q0,-0.58084 0.41097,-0.99181t0.99181,-0.41097t0.99181,0.41097t0.41097,0.99181zm16.13197,0.70139l0,8.36188q0,0.27398 -0.13699,0.42193t-0.43289,0.30138q-2.35623,1.27127 -4.04395,1.27127q-0.66851,0 -1.35346,-0.2411t-1.18908,-0.52604t-1.26579,-0.52604t-1.56169,-0.2411q-2.10417,0 -5.08508,1.60005q-0.18631,0.09863 -0.36165,0.09863q-0.28494,0 -0.49316,-0.20823t-0.20823,-0.49316l0,-8.13174q0,-0.35069 0.33974,-0.60276q0.23014,-0.15343 0.86578,-0.47125q2.58638,-1.31511 4.61383,-1.31511q1.17264,0 2.19184,0.31782t2.40007,0.96441q0.41645,0.20823 0.96441,0.20823q0.5918,0 1.28771,-0.23014t1.20551,-0.51508t0.96441,-0.51508t0.59728,-0.23014q0.28494,0 0.49316,0.20823t0.20823,0.49316z',
			],

			'fa fa-info-circle'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Info Circle', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm13.29181,16.17213l0,-2.0573q0,-0.18001 -0.11572,-0.29574t-0.29574,-0.11572l-1.23438,0l0,-6.58335q0,-0.18001 -0.11572,-0.29574t-0.29574,-0.11572l-4.1146,0q-0.18001,0 -0.29574,0.11572t-0.11572,0.29574l0,2.0573q0,0.18001 0.11572,0.29574t0.29574,0.11572l1.23438,0l0,4.1146l-1.23438,0q-0.18001,0 -0.29574,0.11572t-0.11572,0.29574l0,2.0573q0,0.18001 0.11572,0.29574t0.29574,0.11572l5.76043,0q0.18001,0 0.29574,-0.11572t0.11572,-0.29574zm-1.64584,-11.52087l0,-2.0573q0,-0.18001 -0.11572,-0.29574t-0.29574,-0.11572l-2.46876,0q-0.18001,0 -0.29574,0.11572t-0.11572,0.29574l0,2.0573q0,0.18001 0.11572,0.29574t0.29574,0.11572l2.46876,0q0.18001,0 0.29574,-0.11572t0.11572,-0.29574zm8.22919,5.34898q0,2.68735 -1.32439,4.9568t-3.59384,3.59384t-4.9568,1.32439t-4.9568,-1.32439t-3.59384,-3.59384t-1.32439,-4.9568t1.32439,-4.9568t3.59384,-3.59384t4.9568,-1.32439t4.9568,1.32439t3.59384,3.59384t1.32439,4.9568z',
			],

			'fa fa-male'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Male Figure', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm15.75003,7.63675l0,4.69728q0,0.45166 -0.31616,0.76782t-0.76782,0.31616t-0.76782,-0.31616t-0.31616,-0.76782l0,-3.97462l-0.72266,0l0,10.29789q0,0.51941 -0.37262,0.89203t-0.89203,0.37262t-0.89203,-0.37262t-0.37262,-0.89203l0,-5.23928l-0.72266,0l0,5.23928q0,0.51941 -0.37262,0.89203t-0.89203,0.37262t-0.89203,-0.37262t-0.37262,-0.89203l0,-10.29789l-0.72266,0l0,3.97462q0,0.45166 -0.31616,0.76782t-0.76782,0.31616t-0.76782,-0.31616t-0.31616,-0.76782l0,-4.69728q0,-0.90332 0.63233,-1.53565t1.53565,-0.63233l7.22659,0q0.90332,0 1.53565,0.63233t0.63233,1.53565zm-3.25196,-5.05861q0,1.05011 -0.7396,1.78971t-1.78971,0.7396t-1.78971,-0.7396t-0.7396,-1.78971t0.7396,-1.78971t1.78971,-0.7396t1.78971,0.7396t0.7396,1.78971z',
			],

			'fa fa-plane'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Plane', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm19.61134,0.45318q0.62597,0.73979 0.17072,2.10555t-1.53648,2.44699l-2.2905,2.2905l2.27627,9.90178q0.07113,0.27031 -0.17072,0.46948l-1.82102,1.36576q-0.09959,0.08536 -0.27031,0.08536q-0.05691,0 -0.09959,-0.01423q-0.2134,-0.04268 -0.29876,-0.22763l-3.96925,-7.22716l-3.68472,3.68472l0.75402,2.75998q0.07113,0.24185 -0.11381,0.44103l-1.36576,1.36576q-0.12804,0.12804 -0.32721,0.12804l-0.02845,0q-0.2134,-0.02845 -0.34144,-0.18495l-2.68885,-3.58513l-3.58513,-2.68885q-0.15649,-0.09959 -0.18495,-0.32721q-0.01423,-0.18495 0.12804,-0.35567l1.36576,-1.37999q0.12804,-0.12804 0.32721,-0.12804q0.08536,0 0.11381,0.01423l2.75998,0.75402l3.68472,-3.68472l-7.22716,-3.96925q-0.19917,-0.11381 -0.24185,-0.34144q-0.02845,-0.22763 0.12804,-0.38412l1.82102,-1.82102q0.19917,-0.18495 0.4268,-0.11381l9.46076,2.26205l2.27627,-2.27627q1.08123,-1.08123 2.44699,-1.53648t2.10555,0.17072z',
			],

			'fa fa-arrow-circle-down'        => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Arrow pointing down inside circle', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm16.63189,9.96252q0,-0.34754 -0.2317,-0.57924l-1.17135,-1.17135q-0.2317,-0.2317 -0.57924,-0.2317t-0.57924,0.2317l-2.4328,2.4328l0,-6.46173q0,-0.33467 -0.24457,-0.57924t-0.57924,-0.24457l-1.64761,0q-0.33467,0 -0.57924,0.24457t-0.24457,0.57924l0,6.46173l-2.4328,-2.4328q-0.24457,-0.24457 -0.57924,-0.24457t-0.57924,0.24457l-1.17135,1.17135q-0.2317,0.2317 -0.2317,0.57924t0.2317,0.57924l4.65965,4.65965l1.17135,1.17135q0.2317,0.2317 0.57924,0.2317t0.57924,-0.2317l1.17135,-1.17135l4.65965,-4.65965q0.2317,-0.2317 0.2317,-0.57924zm3.24374,-0.01287q0,2.69024 -1.32581,4.96214t-3.59772,3.59772t-4.96214,1.32581t-4.96214,-1.32581t-3.59772,-3.59772t-1.32581,-4.96214t1.32581,-4.96214t3.59772,-3.59772t4.96214,-1.32581t4.96214,1.32581t3.59772,3.59772t1.32581,4.96214z',
			],
			'fa fa-plus' => [
				/* translators: word to identify a vector icon with this shape */
				'title' => _x( 'Plus Sign', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm19.75015,8.67051l0,2.65911q0,0.55398 -0.38779,0.94177t-0.94177,0.38779l-5.7614,0l0,5.7614q0,0.55398 -0.38779,0.94177t-0.94177,0.38779l-2.65911,0q-0.55398,0 -0.94177,-0.38779t-0.38779,-0.94177l0,-5.7614l-5.7614,0q-0.55398,0 -0.94177,-0.38779t-0.38779,-0.94177l0,-2.65911q0,-0.55398 0.38779,-0.94177t0.94177,-0.38779l5.7614,0l0,-5.7614q0,-0.55398 0.38779,-0.94177t0.94177,-0.38779l2.65911,0q0.55398,0 0.94177,0.38779t0.38779,0.94177l0,5.7614l5.7614,0q0.55398,0 0.94177,0.38779t0.38779,0.94177z',
			],
			'igm_custom_distillery_icon' => [
				'title' => _x( 'Whisky distillery icon', 'Icon Description', 'interactive-geo-maps' ),
				'path' => 'm11.06499,1.13794c-1.46146,0.19011 -2.68344,1.28174 -3.04882,2.72358c-0.02895,0.11419 -0.16553,1.10364 -0.30357,2.19877c-0.13799,1.09518 -0.29037,2.30286 -0.33857,2.68372c-0.0482,0.3809 -0.08766,0.7049 -0.08766,0.72006c0,0.01511 1.01826,0.02749 2.26276,0.02749l2.26276,0l-0.02189,-0.18669c-0.01206,-0.10263 -0.10249,-0.8987 -0.20099,-1.76895c-0.09845,-0.87025 -0.21141,-1.8623 -0.25105,-2.20451c-0.03959,-0.34226 -0.08975,-0.79452 -0.11151,-1.00511l-0.03946,-0.38281l0.10409,-0.20385c0.08311,-0.16271 0.14309,-0.2272 0.29711,-0.31941l0.19297,-0.11556l2.17943,0l2.17948,0l0,-0.69084l0,-0.69084l-0.18669,-0.03709c-0.10268,-0.02039 -0.6187,-0.11692 -1.1467,-0.21455c-3.30264,-0.61069 -3.22864,-0.60013 -3.74171,-0.53341m-4.63285,9.19561c-0.31691,0.36096 -0.74582,1.30008 -0.74582,1.63296l0,0.08516l3.87638,0l3.87638,0l-0.02116,-0.09776c-0.10249,-0.47352 -0.30093,-0.95272 -0.56104,-1.35483c-0.2896,-0.44767 0.1385,-0.39637 -3.30892,-0.39637l-3.00089,0l-0.11492,0.13085m9.74618,1.66468c-0.13836,0.13358 -0.25159,0.26156 -0.25159,0.28441c0,0.05038 1.77509,1.83135 1.8253,1.83135c0.05521,0 0.4859,-0.44416 0.4859,-0.50105c0,-0.02785 -0.4068,-0.45718 -0.90398,-0.95413l-0.90402,-0.90347l-0.25159,0.2429m-12.04021,0.94644c-1.31027,0.74814 -2.25739,1.81082 -2.65053,2.97395l-0.10304,0.30471l0.31299,0.55425c0.17217,0.30485 0.47201,0.83789 0.6664,1.18447l0.35341,0.63017l6.82889,0.00096l6.82894,0.00096l0.316,-0.56003c0.17377,-0.30799 0.47384,-0.83803 0.66677,-1.17787l0.35081,-0.61788l-0.0766,-0.25328c-0.34162,-1.12949 -1.28246,-2.21352 -2.60498,-3.00135l-0.37089,-0.22092l-5.09981,0l-5.09986,0l-0.3185,0.18187',
			],
		];

		$icons = apply_filters( 'igm_available_icons', $icons );

		return $icons;

	}

	public function get_path( $css_class ) {

		$library = $this->get_icons();

		if ( isset( $library[ $css_class ] ) ) {
			return $library[ $css_class ]['path'];
		}

		// default
		return $library['fa fa-star']['path'];

	}

	public function custom_icons( $icons ) {

		$library = $this->get_icons();

		$icons   = array();
		$icons[] = array(
			'title' => __( 'Icons', 'interactive-geo-maps' ),
			'icons' => array_keys( $this->get_icons() ),
		);

		return $icons;

	}

}
