<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_Add_Domain
        {
            var $functions;
            var $woomd_network;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;
                    
                }
                
            function init()
                {
                    
                    $this->run();
                    $this->output();
                    
                }
                
                
            function run()
                {
                    if ( isset($_REQUEST['action']) && 'add-domain' == $_REQUEST['action'] ) 
                        {
                            check_admin_referer( 'add-domain', '_wpnonce_add-domain' );

                            if ( ! is_array( $_POST['blog'] ) )
                                wp_die( __( 'Can&#8217;t create an empty site.' ) );
                            
                            $blog = $_POST['blog'];
                            $domain = strtolower( $blog['domain'] );

                            $title          =   $blog['title'];
                            $description    =   $blog['description'];

                            $meta = array(
                                'public' => 1
                            );
                    
                            if ( empty( $domain ) )
                                wp_die( __( 'Missing or invalid site address.' ) );

                            if ( isset( $blog['email'] ) && '' === trim( $blog['email'] ) ) {
                                wp_die( __( 'Missing email address.' ) );
                            }

                            $email = sanitize_email( $blog['email'] );
                            if ( ! is_email( $email ) ) {
                                wp_die( __( 'Invalid email address.' ) );
                            }

                            $newdomain = $domain;
                            $path      = '/';

                            global $woo_multidomain;
                            
                            $password = 'N/A';
                            $user_id = email_exists($email);
                            if ( !$user_id ) 
                                { // Create a new user with a random password
                                    
                                    do_action( 'woomd/pre_network_site_new_created_user', $email );

                                    $user_id = username_exists( $domain );
                                    if ( $user_id ) {
                                        wp_die( __( 'The domain or path entered conflicts with an existing username.' ) );
                                    }
                                    $password   =   wp_generate_password( 12, false );
                                    $user_id    =   $this->woomd_network->create_user( $domain, $password, $email );
                                    if ( false === $user_id ) {
                                        wp_die( __( 'There was an error creating the user.' ) );
                                    }

                                    /**
                                      * Fires after a new user has been created via the network site-new.php page.
                                      *
                                      * @since 4.4.0
                                      *
                                      * @param int $user_id ID of the newly created user.
                                      */
                                    do_action( 'woomd/network_site_new_created_user', $user_id );
                                }

                            global $wpdb;
                            
                            $wpdb->hide_errors();
                            $id = $this->woomd_network->add_domain( $newdomain, $path, $title, $description, $user_id, $meta );
                            $wpdb->show_errors();
                            if ( ! is_wp_error( $id ) ) 
                                {
                                    if ( ! is_super_admin( $user_id ) && !get_user_option( 'primary_blog', $user_id ) ) 
                                        {
                                            update_user_option( $user_id, 'primary_blog', $id, true );
                                        }

                                    wp_mail(
                                        get_site_option( 'admin_email' ),
                                        sprintf(
                                            /* translators: %s: network name */
                                            __( '[%s] New Domain Created' ),
                                            $this->woomd_network->get_domain_records()->site_name
                                        ),
                                        sprintf(
                                            /* translators: 1: user login, 2: site url, 3: site name/title */
                                            __( 'New domain created by %1$s

                            Address: %2$s
                            Name: %3$s
                            Description: %4$s' ),
                                            $current_user->user_login,
                                            get_site_url( $id ),
                                            wp_unslash( $title ),
                                            wp_unslash( $description )
                                        ),
                                        sprintf(
                                            'From: "%1$s" <%2$s>',
                                            _x( 'Site Admin', 'email "From" field' ),
                                            get_site_option( 'admin_email' )
                                        )
                                    );
                                    wp_redirect( add_query_arg( array( 'page' => 'woo-multidomain', 'updated' => 'domain_created' ), 'admin.php' ) );
                                    exit;
                                } 
                                else 
                                {
                                    wp_die( $id->get_error_message() );
                                }
                        }   
                    
                }
                
                
                
            function output()
                {
                    ?>
                        <div class="wrap">
                            <h1 id="add-new-domain"><?php _e( 'Add New Domain', 'woo-multidomain' ); ?></h1>
                     
                            <form method="post" action="<?php echo admin_url( 'admin.php?page=woo-multidomain-add&action=add-domain' ); ?>" novalidate="novalidate">
                                <?php wp_nonce_field( 'add-domain', '_wpnonce_add-domain' ) ?>
                                <table class="form-table">
                                    <tr class="form-field form-required">
                                        <th scope="row"><label for="site-address"><?php _e( 'Site Address (URL)' ) ?></label></th>
                                        <td>
                                        <?php 
                                             ?><input name="blog[domain]" type="text" class="regular-text" id="site-address" aria-describedby="site-address-desc"  autocapitalize="none" autocorrect="off" />
                                        <?php 
                                        echo '<p class="description" id="site-address-desc">' . __( 'Only lowercase letters (a-z), numbers, and hyphens are allowed.' ) . '</p>';
                                        ?>
                                        </td>
                                    </tr>
                                    <tr class="form-field form-required">
                                        <th scope="row"><label for="site-title"><?php _e( 'Site Title' ) ?></label></th>
                                        <td><input name="blog[title]" type="text" class="regular-text" id="site-title" /></td>
                                    </tr>
                                    <tr class="form-field form-required">
                                        <th scope="row"><label for="blog_last_updated"><?php _e( 'Site Description' ) ?></label></th>
                                        <td><input name="blog[description]" type="text" class="regular-text" id="blog_last_updated" /></td>
                                    </tr>
                             
                                    
                                    <tr class="form-field form-required">
                                        <th scope="row"><label for="admin-email"><?php _e( 'Admin Email' ) ?></label></th>
                                        <td><input name="blog[email]" type="email" class="regular-text wp-suggest-user" id="admin-email" data-autocomplete-type="search" data-autocomplete-field="user_email" /></td>
                                    </tr>
                                    <tr class="form-field">
                                        <td colspan="2"><?php _e( 'A new user will be created if the above email address is not in the database.' ) ?><br /><?php _e( 'The username and a link to set the password will be mailed to this email address.' ) ?></td>
                                    </tr>
                                </table>

                                <?php submit_button( __( 'Add Site' ), 'primary', 'add-site' ); ?>
                            </form>
                        </div>
                    <?php  
                    
                }
            
        }