<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_Domain_Edit_Info
        {
            var $functions;
            var $woomd_network;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;
                    
                }
                
                
            function init()
                {
                    
                    $this->run();
                    $this->output();
                    
                }
                
                
                
            static function set_screen_data()
                {

                    get_current_screen()->add_help_tab( array(
                        'id'      => 'overview',
                        'title'   => __('Overview'),
                        'content' =>
                            '<p>' . __('The menu is for editing information specific to individual sites, particularly if the admin area of a site is unavailable.') . '</p>' .
                            '<p>' . __('<strong>Info</strong> &mdash; The site URL is rarely edited as this can cause the site to not work properly. The Registered date and Last Updated date are displayed. Network admins can mark a site as archived, spam, deleted and mature, to remove from public listings or disable.') . '</p>' .
                            '<p>' . sprintf( __('<strong>Themes</strong> &mdash; This area shows themes that are not already enabled across the network. Enabling a theme in this menu makes it accessible to this site. It does not activate the theme, but allows it to show in the site&#8217;s Appearance menu. To enable a theme for the entire network, see the <a href="%s">Network Themes</a> screen.' ), network_admin_url( 'themes.php' ) ) . '</p>' .
                            '<p>' . __('<strong>Settings</strong> &mdash; This page shows a list of all settings associated with this site. Some are created by WordPress and others are created by plugins you activate. Note that some fields are grayed out and say Serialized Data. You cannot modify these values due to the way the setting is stored in the database.') . '</p>'
                    ));
                    
                    get_current_screen()->set_help_sidebar(
                        '<p><strong>' . __('For more information:') . '</strong></p>' 
                        // . '<p>' . __('<a href="https://codex.wordpress.org/Network_Admin_Sites_Screen">Documentation on Site Management</a>') . '</p>' .
                    );
                    
                    
                }
                
                
            function run()
                {

                        $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;

                        if ( ! $id ) {
                            wp_die( __( 'Invalid site ID.' ) );
                        }

                        $details = $this->woomd_network->get_domain( $id );
                        if ( ! $details ) {
                            wp_die( __( 'The requested site does not exist.' ) );
                        }

                        $parsed_scheme = parse_url( $details->siteurl, PHP_URL_SCHEME );
                        $is_main_site  = $this->woomd_network->is_main_domain( $id );

                        if ( isset( $_REQUEST['action'] ) && 'update-domain' == $_REQUEST['action'] ) 
                            {
                                check_admin_referer( 'edit-domain' );

                                $this->woomd_network->switch_to_domain( $id );

                                $domain_data            =   wp_unslash( $_POST['blog'] );
                                $domain_data['scheme']  =   $parsed_scheme;

                                if ( $is_main_site ) 
                                {
                                    // On the network's main site, don't allow the domain or path to change.
                                    $domain_data['domain'] = $details->domain;
                                    $domain_data['path']   = $details->path;
                                } 
                                else 
                                    {
                                        // For any other site, the scheme, domain, and path can all be changed. We first
                                        // need to ensure a scheme has been provided, otherwise fallback to the existing.
                                        $new_url_scheme = parse_url( $domain_data['url'], PHP_URL_SCHEME );

                                        if ( ! $new_url_scheme ) {
                                            $domain_data['url'] = esc_url( $parsed_scheme . '://' . $domain_data['url'] );
                                        }
                                        $update_parsed_url = parse_url( $domain_data['url'] );

                                        // If a path is not provided, use the default of `/`.
                                        if ( ! isset( $update_parsed_url['path'] ) ) {
                                            $update_parsed_url['path'] = '/';
                                        }

                                        $domain_data['scheme'] = $update_parsed_url['scheme'];
                                        $domain_data['domain'] = $update_parsed_url['host'];
                                        $domain_data['path']   = $update_parsed_url['path'];
                                    }

                                $existing_details     = $this->woomd_network->get_domain( $id );
                                $this->woomd_network->update_domain_details( $id, $domain_data );

                                // Maybe update home and siteurl options.
                                $new_details    =   $this->woomd_network->get_domain( $id );

                                $old_home_url    = trailingslashit( esc_url( get_option( 'home' ) ) );
                                $old_home_parsed = parse_url( $old_home_url );

                                if ( $old_home_parsed['host'] === $existing_details->domain && $old_home_parsed['path'] === $existing_details->path ) {
                                    $new_home_url = untrailingslashit( esc_url_raw( $domain_data['scheme'] . '://' . $new_details->domain . $new_details->path ) );
                                    update_option( 'home', $new_home_url );
                                }

                                $old_site_url    = trailingslashit( esc_url( get_option( 'siteurl' ) ) );
                                $old_site_parsed = parse_url( $old_site_url );

                                if ( $old_site_parsed['host'] === $existing_details->domain && $old_site_parsed['path'] === $existing_details->path ) {
                                    $new_site_url = untrailingslashit( esc_url_raw( $domain_data['scheme'] . '://' . $new_details->domain . $new_details->path ) );
                                    update_option( 'siteurl', $new_site_url );
                                }
                                
                                //update title
                                $title          =   strip_tags( $domain_data['title'] );
                                update_option( 'blogname', $title );
                                
                                //update description
                                $description    =   strip_tags( $domain_data['description'] ); 
                                update_option( 'blogdescription', $description );                                

                                $this->woomd_network->restore_current_domain();
                                
                                wp_redirect(
                                            add_query_arg(
                                                array(
                                                    'page'      =>  'woo-multidomain',
                                                    'section'   =>  'domain-edit',
                                                    'update'    =>  'updated',
                                                    'id'        =>  $id,
                                                ),
                                                'admin.php'
                                            )
                                        );
                                exit;
                            }   
                    
                    
                }
                
                
            function output()
                {

                    $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;
               
                    $details = $this->woomd_network->get_domain( $id );
                    if ( ! $details ) {
                        wp_die( __( 'The requested domain does not exist.' ) );
                    }

                    $parsed_scheme = parse_url( $details->siteurl, PHP_URL_SCHEME );
                    $is_main_site  = $id    === 1   ?   TRUE    :   FALSE;

               
                    if ( isset( $_GET['update'] ) ) {
                        $messages = array();
                        if ( 'updated' == $_GET['update'] ) {
                            $messages[] = __( 'Domain info updated.' );
                        }
                    }

                    /* translators: %s: site name */
                    $title = sprintf( __( 'Edit Domain: %s' ), esc_html( $details->blogname ) );

                    ?>

                    <div class="wrap">
                        <h1 id="edit-site"><?php echo $title; ?></h1>
                        <?php $this->woomd_network->switch_to_domain( $id ); ?>
                        <p class="edit-site-actions"><a href="<?php echo esc_url( get_home_url( $id, '/' ) ); ?>"><?php _e( 'Visit' ); ?></a> | <a href="<?php echo esc_url( get_admin_url( $id ) ); ?>"><?php _e( 'Dashboard' ); ?></a></p>
                        <?php $this->woomd_network->restore_current_domain(); ?>
                        <?php

                        if ( ! empty( $messages ) ) {
                            foreach ( $messages as $msg ) {
                                echo '<div id="message" class="updated notice is-dismissible"><p>' . $msg . '</p></div>';
                            }
                        }

                        $current_tab    =   isset($_GET['tab']) ? $_GET['tab']    :   'domain-info'; 
                        
                        global $woo_multidomain;
                        
                        $woo_multidomain->admin_interface->network_edit_domain_nav(
                                                                            array(
                                                                                'blog_id'  => $id,
                                                                                'selected' => $current_tab,
                                                                            )
                                                                        );
                       
                        
                        ?>
                        <form method="post" action="admin.php?page=woo-multidomain&section=domain-edit&action=update-domain">
                            <?php wp_nonce_field( 'edit-domain' ); ?>
                            <input type="hidden" name="id" value="<?php echo esc_attr( $id ); ?>" />
                            <table class="form-table">
                                <?php
                                // The main site of the network should not be updated on this page.
                                if ( $is_main_site ) :
                                    ?>
                                    <tr class="form-field">
                                        <th scope="row"><?php _e( 'Domain Address (URL)' ); ?></th>
                                        <td><?php echo esc_url( $parsed_scheme . '://' . $details->domain . $details->path ); ?></td>
                                    </tr>
                                        <?php
                                        // For any other site, the scheme, domain, and path can all be changed.
                                else :
                                    ?>
                                    <tr class="form-field form-required">
                                        <th scope="row"><?php _e( 'Domain Address (URL)' ); ?></th>
                                        <td><input name="blog[url]" type="text" id="url" value="<?php echo $parsed_scheme . '://' . esc_attr( $details->domain ) . esc_attr( $details->path ); ?>" /></td>
                                    </tr>
                                <?php endif; ?>

                                <tr class="form-field">
                                    <th scope="row"><label for="site-title"><?php _ex( 'Site Title', 'site' ); ?></label></th>
                                    <td><input name="blog[title]" type="text" id="site-title" value="<?php echo esc_attr( $details->blogname ); ?>" /></td>
                                </tr>
                                
                                <tr class="form-field">
                                    <th scope="row"><label for="blog_last_updated"><?php _ex( 'Site Description', 'site' ); ?></label></th>
                                    <td><input name="blog[description]" type="text" id="blog_last_updated" value="<?php echo esc_attr( $details->blogdescription ); ?>" /></td>
                                </tr>
                                
                                <tr class="form-field">
                                    <th scope="row"><label for="blog_last_updated"><?php _ex( 'Last Updated', 'site' ); ?></label></th>
                                    <td><input name="blog[last_updated]" type="text" id="blog_last_updated" value="<?php echo esc_attr( $details->last_updated ); ?>" /></td>
                                </tr>
                              
                            </table>
                            <?php submit_button(); ?>
                        </form>   
               

                    </div>
                    <?php
                    
                }
                
        }
    

    
    
?>