<?php
    
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_Domain_Edit_Themes
        {
            var $functions;
            var $woomd_network;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;
                    
                }
                
                
            function init()
                {
                    
                    $this->run();
                    $this->output();
                    
                }
                
                
            static function set_screen_data()
                {

                    // Help tab: Overview
                    if ( current_user_can( 'switch_themes' ) ) {
                        $help_overview = '<p>' . __( 'This screen is used for managing your installed themes. Aside from the default theme(s) included with your WordPress installation, themes are designed and developed by third parties.' ) . '</p>' .
                            '<p>' . __( 'From this screen you can:' ) . '</p>' .
                            '<ul><li>' . __( 'Hover or tap to see Activate and Live Preview buttons' ) . '</li>' .
                            '<li>' . __( 'Click on the theme to see the theme name, version, author, description, tags, and the Delete link' ) . '</li>' .
                            '<li>' . __( 'Click Customize for the current theme or Live Preview for any other theme to see a live preview' ) . '</li></ul>' .
                            '<p>' . __( 'The current theme is displayed highlighted as the first theme.' ) . '</p>' .
                            '<p>' . __( 'The search for installed themes will search for terms in their name, description, author, or tag.' ) . ' <span id="live-search-desc">' . __( 'The search results will be updated as you type.' ) . '</span></p>';

                        get_current_screen()->add_help_tab(
                            array(
                                'id'      => 'overview',
                                'title'   => __( 'Overview' ),
                                'content' => $help_overview,
                            )
                        );
                    } // switch_themes

                    // Help tab: Adding Themes
                    if ( current_user_can( 'install_themes' ) ) {
                        if ( is_multisite() ) {
                            $help_install = '<p>' . __( 'Installing themes on Multisite can only be done from the Network Admin section.' ) . '</p>';
                        } else {
                            $help_install = '<p>' . sprintf( __( 'If you would like to see more themes to choose from, click on the &#8220;Add New&#8221; button and you will be able to browse or search for additional themes from the <a href="%s">WordPress Theme Directory</a>. Themes in the WordPress Theme Directory are designed and developed by third parties, and are compatible with the license WordPress uses. Oh, and they&#8217;re free!' ), __( 'https://wordpress.org/themes/' ) ) . '</p>';
                        }

                        get_current_screen()->add_help_tab(
                            array(
                                'id'      => 'adding-themes',
                                'title'   => __( 'Adding Themes' ),
                                'content' => $help_install,
                            )
                        );
                    } // install_themes

                    // Help tab: Previewing and Customizing
                    if ( current_user_can( 'edit_theme_options' ) && current_user_can( 'customize' ) ) {
                        $help_customize =
                            '<p>' . __( 'Tap or hover on any theme then click the Live Preview button to see a live preview of that theme and change theme options in a separate, full-screen view. You can also find a Live Preview button at the bottom of the theme details screen. Any installed theme can be previewed and customized in this way.' ) . '</p>' .
                            '<p>' . __( 'The theme being previewed is fully interactive &mdash; navigate to different pages to see how the theme handles posts, archives, and other page templates. The settings may differ depending on what theme features the theme being previewed supports. To accept the new settings and activate the theme all in one step, click the Publish &amp; Activate button above the menu.' ) . '</p>' .
                            '<p>' . __( 'When previewing on smaller monitors, you can use the collapse icon at the bottom of the left-hand pane. This will hide the pane, giving you more room to preview your site in the new theme. To bring the pane back, click on the collapse icon again.' ) . '</p>';

                        get_current_screen()->add_help_tab(
                            array(
                                'id'      => 'customize-preview-themes',
                                'title'   => __( 'Previewing and Customizing' ),
                                'content' => $help_customize,
                            )
                        );
                    } // edit_theme_options && customize

                    get_current_screen()->set_help_sidebar(
                        '<p><strong>' . __( 'For more information:' ) . '</strong></p>' .
                        '<p>' . __( '<a href="https://codex.wordpress.org/Using_Themes">Documentation on Using Themes</a>' ) . '</p>' .
                        '<p>' . __( '<a href="https://wordpress.org/support/">Support Forums</a>' ) . '</p>'
                    );
                    
                    
                }
                
            
            function run()
                {
                    global $woo_multidomain;

                    if ( ! current_user_can( 'switch_themes' ) && ! current_user_can( 'edit_theme_options' ) ) {
                        wp_die(
                            '<h1>' . __( 'You need a higher level of permission.' ) . '</h1>' .
                            '<p>' . __( 'Sorry, you are not allowed to edit theme options on this domain.' ) . '</p>',
                            403
                        );
                    }

                  
                    if ( current_user_can( 'switch_themes' ) && isset( $_GET['action'] ) ) 
                        {
                            if ( 'activate' == $_GET['action'] ) 
                                {
                                    check_admin_referer( 'switch-theme_' . $_GET['stylesheet'] );
                                    $theme = wp_get_theme( $_GET['stylesheet'] );

                                    if ( ! $theme->exists() || ! $theme->is_allowed() ) {
                                        wp_die(
                                            '<h1>' . __( 'Something went wrong.' ) . '</h1>' .
                                            '<p>' . __( 'The requested theme does not exist.' ) . '</p>',
                                            403
                                        );
                                    }

                                    switch_theme( $theme->get_stylesheet() );
                                    wp_redirect( admin_url( 'themes.php?activated=true' ) );
                                    exit;
                                }
                        }
                       
                    
                }
                
                
                
            function output()
                {
                    $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;
                    
                    $details = $this->woomd_network->get_domain( $id );
                    if ( ! $details ) {
                        wp_die( __( 'The requested domain does not exist.' ) );
                    }
                    
                    /* translators: %s: site name */
                    $title = sprintf( __( 'Edit Domain: %s' ), esc_html( $details->blogname ) );
                    
                    ?>

                    <div class="wrap">
                        <h1 id="edit-site"><?php echo $title; ?></h1>
                        <?php $this->woomd_network->switch_to_domain( $id ); ?>
                        <p class="edit-site-actions"><a href="<?php echo esc_url( get_home_url( $id, '/' ) ); ?>"><?php _e( 'Visit' ); ?></a> | <a href="<?php echo esc_url( get_admin_url( $id ) ); ?>"><?php _e( 'Dashboard' ); ?></a></p>
                        <?php $this->woomd_network->restore_current_domain(); ?>
                        <?php
                        

                        $current_tab    =   isset($_GET['tab']) ? $_GET['tab']    :   'domain-info'; 
                        
                        global $woo_multidomain;
                        
                        $woo_multidomain->admin_interface->network_edit_domain_nav(
                                                                            array(
                                                                                'blog_id'  => $id,
                                                                                'selected' => $current_tab,
                                                                            )
                                                                        );
                                   
                        $this->woomd_network->switch_to_domain( $id );
                        
                        $themes =   $this->wp_prepare_themes_for_js( $id );
                        
                        $this->woomd_network->restore_current_domain();
                        
                        wp_reset_vars( array( 'theme', 'search' ) );

                        wp_localize_script(
                            'theme',
                            '_wpThemeSettings',
                            array(
                                'themes'   => $themes,
                                'settings' => array(
                                    'canInstall'    => ( ! is_multisite() && current_user_can( 'install_themes' ) ),
                                    'installURI'    => ( ! is_multisite() && current_user_can( 'install_themes' ) ) ? admin_url( 'theme-install.php' ) : null,
                                    'confirmDelete' => __( "Are you sure you want to delete this theme?\n\nClick 'Cancel' to go back, 'OK' to confirm the delete." ),
                                    'adminUrl'      => parse_url( admin_url(), PHP_URL_PATH ),
                                ),
                                'l10n'     => array(
                                    'addNew'            => __( 'Add New Theme' ),
                                    'search'            => __( 'Search Installed Themes' ),
                                    'searchPlaceholder' => __( 'Search installed themes...' ), // placeholder (no ellipsis)
                                    'themesFound'       => __( 'Number of Themes found: %d' ),
                                    'noThemesFound'     => __( 'No themes found. Try a different search.' ),
                                ),
                            )
                        );

                        add_thickbox();
                        wp_enqueue_script( 'theme' );
                        wp_enqueue_script( 'updates' );
                            
                        ?>
                        <div class="themes-php">
                            <div class="wrap">
                                <h1 class="wp-heading-inline"><?php esc_html_e( 'Themes' ); ?>
                                    <span class="title-count theme-count"><?php echo ! empty( $_GET['search'] ) ? __( '&hellip;' ) : count( $themes ); ?></span>
                                </h1>

                                <?php if ( ! is_multisite() && current_user_can( 'install_themes' ) ) : ?>
                                    <a href="<?php echo admin_url( 'theme-install.php' ); ?>" class="hide-if-no-js page-title-action"><?php echo esc_html_x( 'Add New', 'Add new theme' ); ?></a>
                                <?php endif; ?>

                                <form class="search-form"></form>

                                <hr class="wp-header-end">
                            <?php
                          
                            $ct = wp_get_theme();

                            if ( $ct->errors() && ( ! is_multisite() || current_user_can( 'manage_network_themes' ) ) ) 
                                {
                                    echo '<div class="error"><p>' . __( 'ERROR:' ) . ' ' . $ct->errors()->get_error_message() . '</p></div>';
                                }
                
                            $class_name = 'theme-browser';
                            if ( ! empty( $_GET['search'] ) ) 
                                {
                                    $class_name .= ' search-loading';
                                }
                            ?>
                            <div class="<?php echo esc_attr( $class_name ); ?>">
                                <div class="themes wp-clearfix">
                                
                                
                                
                                <?php
                            
                            global $blog_id;
                            
                            foreach ( $themes as $theme ) 
                                {
                                    $aria_action = esc_attr( $theme['id'] . '-action' );
                                    $aria_name   = esc_attr( $theme['id'] . '-name' );

                                    $active_class = '';
                                    if ( $theme['active'] ) {
                                        $active_class = ' active';
                                    }
                                    ?>
                                    <div class="theme<?php echo $active_class; ?>" tabindex="0" aria-describedby="<?php echo $aria_action . ' ' . $aria_name; ?>">
                                        <?php if ( ! empty( $theme['screenshot'][0] ) ) { ?>
                                            <div class="theme-screenshot">
                                                <img src="<?php echo $theme['screenshot'][0]; ?>" alt="" />
                                            </div>
                                        <?php } else { ?>
                                            <div class="theme-screenshot blank"></div>
                                        <?php } ?>

                                        <?php if ( $theme['hasUpdate'] ) : ?>
                                            <div class="update-message notice inline notice-warning notice-alt">
                                            <?php if ( $theme['hasPackage'] ) : ?>
                                                <p><?php _e( 'New version available. <button class="button-link" type="button">Update now</button>' ); ?></p>
                                            <?php else : ?>
                                                <p><?php _e( 'New version available.' ); ?></p>
                                            <?php endif; ?>
                                            </div>
                                        <?php endif; ?>

                                        <span class="more-details" id="<?php echo $aria_action; ?>"><?php _e( 'Theme Details' ); ?></span>
                                        <div class="theme-author"><?php printf( __( 'By %s' ), $theme['author'] ); ?></div>

                                        <div class="theme-id-container">
                                            <?php if ( $theme['active'] ) { ?>
                                                <h2 class="theme-name" id="<?php echo $aria_name; ?>">
                                                    <?php
                                                    /* translators: %s: theme name */
                                                    printf( __( '<span>Active:</span> %s' ), $theme['name'] );
                                                    ?>
                                                </h2>
                                            <?php } else { ?>
                                                <h2 class="theme-name" id="<?php echo $aria_name; ?>"><?php echo $theme['name']; ?></h2>
                                            <?php } ?>

                                            <div class="theme-actions">
                                            <?php if ( $theme['active'] ) { ?>
                                                <?php if ( $theme['actions']['customize'] && current_user_can( 'edit_theme_options' ) && current_user_can( 'customize' ) ) { ?>
                                                    <a class="button button-primary customize load-customize hide-if-no-customize" href="<?php echo $theme['actions']['customize']; ?>"><?php _e( 'Customize' ); ?></a>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <?php
                                                /* translators: %s: Theme name */
                                                $aria_label = sprintf( _x( 'Activate %s', 'theme' ), '{{ data.name }}' );
                                                
                                                if  ( isset ($theme['actions']['activate'] )    &&   ! empty ( $theme['actions']['activate'] ) )
                                                    {
                                                        ?>
                                                            <a class="button activate" href="<?php echo $theme['actions']['activate']; ?>" aria-label="<?php echo esc_attr( $aria_label ); ?>"><?php _e( 'Activate' ); ?></a>
                                                        <?php 
                                                    }
                                                if ( current_user_can( 'edit_theme_options' ) && current_user_can( 'customize' ) ) { ?>
                                                    <a class="button button-primary load-customize hide-if-no-customize" href="<?php echo $theme['actions']['customize']; ?>"><?php _e( 'Live Preview' ); ?></a>
                                                <?php } ?>
                                            <?php } ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                </div>
                            </div>
                            <div class="theme-overlay" tabindex="0" role="dialog" aria-label="<?php esc_attr_e( 'Theme Details' ); ?>"></div>

                            <p class="no-themes"><?php _e( 'No themes found. Try a different search.' ); ?></p>

                            <?php
                            // List broken themes, if any.
                            if ( ! is_multisite() && current_user_can( 'edit_themes' ) && $broken_themes = wp_get_themes( array( 'errors' => true ) ) ) 
                                {
                                    ?>
                                        <div class="broken-themes">
                                        <h3><?php _e( 'Broken Themes' ); ?></h3>
                                        <p><?php _e( 'The following themes are installed but incomplete.' ); ?></p>

                                            <?php
                                            $can_delete  = current_user_can( 'delete_themes' );
                                            $can_install = current_user_can( 'install_themes' );
                                            ?>
                                        <table>
                                            <tr>
                                                <th><?php _ex( 'Name', 'theme name' ); ?></th>
                                                <th><?php _e( 'Description' ); ?></th>
                                                <?php if ( $can_delete ) { ?>
                                                    <td></td>
                                                <?php } ?>
                                                <?php if ( $can_install ) { ?>
                                                    <td></td>
                                                <?php } ?>
                                            </tr>
                                            <?php foreach ( $broken_themes as $broken_theme ) : ?>
                                                <tr>
                                                    <td><?php echo $broken_theme->get( 'Name' ) ? $broken_theme->display( 'Name' ) : $broken_theme->get_stylesheet(); ?></td>
                                                    <td><?php echo $broken_theme->errors()->get_error_message(); ?></td>
                                                    <?php
                                                    if ( $can_delete ) {
                                                        $stylesheet = $broken_theme->get_stylesheet();
                                                        $delete_url = add_query_arg(
                                                            array(
                                                                'action'     => 'delete',
                                                                'stylesheet' => urlencode( $stylesheet ),
                                                            ),
                                                            admin_url( 'themes.php' )
                                                        );
                                                        $delete_url = wp_nonce_url( $delete_url, 'delete-theme_' . $stylesheet );
                                                        ?>
                                                        <td><a href="<?php echo esc_url( $delete_url ); ?>" class="button delete-theme"><?php _e( 'Delete' ); ?></a></td>
                                                        <?php
                                                    }

                                                    if ( $can_install && 'theme_no_parent' === $broken_theme->errors()->get_error_code() ) {
                                                        $parent_theme_name = $broken_theme->get( 'Template' );
                                                        $parent_theme      = themes_api( 'theme_information', array( 'slug' => urlencode( $parent_theme_name ) ) );

                                                        if ( ! is_wp_error( $parent_theme ) ) {
                                                            $install_url = add_query_arg(
                                                                array(
                                                                    'action' => 'install-theme',
                                                                    'theme'  => urlencode( $parent_theme_name ),
                                                                ),
                                                                admin_url( 'update.php' )
                                                            );
                                                            $install_url = wp_nonce_url( $install_url, 'install-theme_' . $parent_theme_name );
                                                            ?>
                                                            <td><a href="<?php echo esc_url( $install_url ); ?>" class="button install-theme"><?php _e( 'Install Parent Theme' ); ?></a></td>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </tr>
                                            <?php endforeach; ?>
                                        </table>
                                        </div>
                                    <?php
                                }
                            ?>
                            </div><!-- .wrap -->
                        </div>
                        <?php
                        /*
                         * The tmpl-theme template is synchronized with PHP above!
                         */
                        ?>
                        <script id="tmpl-theme" type="text/template">
                            <# if ( data.screenshot[0] ) { #>
                                <div class="theme-screenshot">
                                    <img src="{{ data.screenshot[0] }}" alt="" />
                                </div>
                            <# } else { #>
                                <div class="theme-screenshot blank"></div>
                            <# } #>

                            <# if ( data.hasUpdate ) { #>
                                <# if ( data.hasPackage ) { #>
                                    <div class="update-message notice inline notice-warning notice-alt"><p><?php _e( 'New version available. <button class="button-link" type="button">Update now</button>' ); ?></p></div>
                                <# } else { #>
                                    <div class="update-message notice inline notice-warning notice-alt"><p><?php _e( 'New version available.' ); ?></p></div>
                                <# } #>
                            <# } #>

                            <span class="more-details" id="{{ data.id }}-action"><?php _e( 'Theme Details' ); ?></span>
                            <div class="theme-author">
                                <?php
                                /* translators: %s: Theme author name */
                                printf( __( 'By %s' ), '{{{ data.author }}}' );
                                ?>
                            </div>

                            <div class="theme-id-container">
                                <# if ( data.active ) { #>
                                    <h2 class="theme-name" id="{{ data.id }}-name">
                                        <?php
                                        /* translators: %s: Theme name */
                                        printf( __( '<span>Active:</span> %s' ), '{{{ data.name }}}' );
                                        ?>
                                    </h2>
                                <# } else { #>
                                    <h2 class="theme-name" id="{{ data.id }}-name">{{{ data.name }}}</h2>
                                <# } #>

                                <div class="theme-actions">
                                    <# if ( data.active ) { #>
                                        <# if ( data.actions.customize ) { #>
                                            <a class="button button-primary customize load-customize hide-if-no-customize" href="{{{ data.actions.customize }}}"><?php _e( 'Customize' ); ?></a>
                                        <# } #>
                                    <# } else { #>
                                        <?php
                                        /* translators: %s: Theme name */
                                        $aria_label = sprintf( _x( 'Activate %s', 'theme' ), '{{ data.name }}' );
                                        ?>
                                        <a class="button activate" href="{{{ data.actions.activate }}}" aria-label="<?php echo $aria_label; ?>"><?php _e( 'Activate' ); ?></a>
                                        <a class="button button-primary load-customize hide-if-no-customize" href="{{{ data.actions.customize }}}"><?php _e( 'Live Preview' ); ?></a>
                                    <# } #>
                                </div>
                            </div>
                        </script>

                        <script id="tmpl-theme-single" type="text/template">
                            <div class="theme-backdrop"></div>
                            <div class="theme-wrap wp-clearfix" role="document">
                                <div class="theme-header">
                                    <button class="left dashicons dashicons-no"><span class="screen-reader-text"><?php _e( 'Show previous theme' ); ?></span></button>
                                    <button class="right dashicons dashicons-no"><span class="screen-reader-text"><?php _e( 'Show next theme' ); ?></span></button>
                                    <button class="close dashicons dashicons-no"><span class="screen-reader-text"><?php _e( 'Close details dialog' ); ?></span></button>
                                </div>
                                <div class="theme-about wp-clearfix">
                                    <div class="theme-screenshots">
                                    <# if ( data.screenshot[0] ) { #>
                                        <div class="screenshot"><img src="{{ data.screenshot[0] }}" alt="" /></div>
                                    <# } else { #>
                                        <div class="screenshot blank"></div>
                                    <# } #>
                                    </div>

                                    <div class="theme-info">
                                        <# if ( data.active ) { #>
                                            <span class="current-label"><?php _e( 'Current Theme' ); ?></span>
                                        <# } #>
                                        <h2 class="theme-name">{{{ data.name }}}<span class="theme-version"><?php printf( __( 'Version: %s' ), '{{ data.version }}' ); ?></span></h2>
                                        <p class="theme-author"><?php printf( __( 'By %s' ), '{{{ data.authorAndUri }}}' ); ?></p>

                                        <# if ( data.hasUpdate ) { #>
                                        <div class="notice notice-warning notice-alt notice-large">
                                            <h3 class="notice-title"><?php _e( 'Update Available' ); ?></h3>
                                            {{{ data.update }}}
                                        </div>
                                        <# } #>
                                        <p class="theme-description">{{{ data.description }}}</p>

                                        <# if ( data.parent ) { #>
                                            <p class="parent-theme"><?php printf( __( 'This is a child theme of %s.' ), '<strong>{{{ data.parent }}}</strong>' ); ?></p>
                                        <# } #>

                                        <# if ( data.tags ) { #>
                                            <p class="theme-tags"><span><?php _e( 'Tags:' ); ?></span> {{{ data.tags }}}</p>
                                        <# } #>
                                    </div>
                                </div>

                                <div class="theme-actions">
                                    <div class="active-theme">
                                        <a href="{{{ data.actions.customize }}}" class="button button-primary customize load-customize hide-if-no-customize"><?php _e( 'Customize' ); ?></a>
                                        <?php echo implode( ' ', $current_theme_actions ); ?>
                                    </div>
                                    <div class="inactive-theme">
                                        <?php
                                        /* translators: %s: Theme name */
                                        $aria_label = sprintf( _x( 'Activate %s', 'theme' ), '{{ data.name }}' );
                                        ?>
                                        <# if ( data.actions.activate ) { #>
                                            <a href="{{{ data.actions.activate }}}" class="button activate" aria-label="<?php echo $aria_label; ?>"><?php _e( 'Activate' ); ?></a>
                                        <# } #>
                                        <a href="{{{ data.actions.customize }}}" class="button button-primary load-customize hide-if-no-customize"><?php _e( 'Live Preview' ); ?></a>
                                    </div>

                                    <# if ( ! data.active && data.actions['delete'] ) { #>
                                        <a href="{{{ data.actions['delete'] }}}" class="button delete-theme"><?php _e( 'Delete' ); ?></a>
                                    <# } #>
                                </div>
                            </div>
                        </script>

                        <?php
                        wp_print_request_filesystem_credentials_modal();
                        wp_print_admin_notice_templates();
                        wp_print_update_row_templates();

                        wp_localize_script(
                            'updates',
                            '_wpUpdatesItemCounts',
                            array(
                                'totals' => wp_get_update_data(),
                            )
                        );
       
                        ?>

                    </div>
                    <?php
                    
                }
                
                
            /**
             * Prepare themes for JavaScript.
             *
             * @since 3.8.0
             *
             * @param WP_Theme[] $themes Optional. Array of theme objects to prepare.
             *                           Defaults to all allowed themes.
             *
             * @return array An associative array of theme data, sorted by name.
             */
            function wp_prepare_themes_for_js( $domain_id, $themes = null ) 
                {
                    $current_theme = get_stylesheet();

                    /**
                     * Filters theme data before it is prepared for JavaScript.
                     *
                     * Passing a non-empty array will result in wp_prepare_themes_for_js() returning
                     * early with that value instead.
                     *
                     * @since 4.2.0
                     *
                     * @param array           $prepared_themes An associative array of theme data. Default empty array.
                     * @param WP_Theme[]|null $themes          An array of theme objects to prepare, if any.
                     * @param string          $current_theme   The current theme slug.
                     */
                    $prepared_themes = (array) apply_filters( 'pre_prepare_themes_for_js', array(), $themes, $current_theme );

                    if ( ! empty( $prepared_themes ) ) {
                        return $prepared_themes;
                    }

                    // Make sure the current theme is listed first.
                    $prepared_themes[ $current_theme ] = array();

                    if ( null === $themes ) {
                        $themes = wp_get_themes( array( 'allowed' => true ) );
                        if ( ! isset( $themes[ $current_theme ] ) ) {
                            $themes[ $current_theme ] = wp_get_theme();
                        }
                    }

                    $updates = array();
                    if ( current_user_can( 'update_themes' ) ) {
                        $updates_transient = get_site_transient( 'update_themes' );
                        if ( isset( $updates_transient->response ) ) {
                            $updates = $updates_transient->response;
                        }
                    }

                    WP_Theme::sort_by_name( $themes );

                    $parents = array();

                    foreach ( $themes as $theme ) {
                        $slug         = $theme->get_stylesheet();
                        $encoded_slug = urlencode( $slug );

                        $parent = false;
                        if ( $theme->parent() ) {
                            $parent           = $theme->parent();
                            $parents[ $slug ] = $parent->get_stylesheet();
                            $parent           = $parent->display( 'Name' );
                        }

                        $customize_action = null;
                        if ( current_user_can( 'edit_theme_options' ) && current_user_can( 'customize' ) ) {
                            $customize_action = esc_url(
                                add_query_arg(
                                    array(
                                        'return' => urlencode( esc_url_raw( remove_query_arg( wp_removable_query_args(), wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) ),
                                    ),
                                    wp_customize_url( $slug )
                                )
                            );
                        }

                        $prepared_themes[ $slug ] = array(
                            'id'           => $slug,
                            'name'         => $theme->display( 'Name' ),
                            'screenshot'   => array( $theme->get_screenshot() ), // @todo multiple
                            'description'  => $theme->display( 'Description' ),
                            'author'       => $theme->display( 'Author', false, true ),
                            'authorAndUri' => $theme->display( 'Author' ),
                            'version'      => $theme->display( 'Version' ),
                            'tags'         => $theme->display( 'Tags' ),
                            'parent'       => $parent,
                            'active'       => $slug === $current_theme,
                            'hasUpdate'    => isset( $updates[ $slug ] ),
                            'hasPackage'   => isset( $updates[ $slug ] ) && ! empty( $updates[ $slug ]['package'] ),
                            'update'       => get_theme_update_available( $theme )
                           
                        );
                        
                        
                        $prepared_themes[ $slug ]['actions']    =   array(
                                'activate'  => current_user_can( 'switch_themes' ) ? admin_url( 'themes.php' ) : null,
                                'customize' => $customize_action,
                                'delete'    => current_user_can( 'delete_themes' ) ? wp_nonce_url( admin_url( 'themes.php?action=delete&amp;stylesheet=' . $encoded_slug ), 'delete-theme_' . $slug ) : null,
                            );
                           
                    }

                    // Remove 'delete' action if theme has an active child
                    if ( ! empty( $parents ) && array_key_exists( $current_theme, $parents ) ) {
                        unset( $prepared_themes[ $parents[ $current_theme ] ]['actions']['delete'] );
                    }

                    /**
                     * Filters the themes prepared for JavaScript, for themes.php.
                     *
                     * Could be useful for changing the order, which is by name by default.
                     *
                     * @since 3.8.0
                     *
                     * @param array $prepared_themes Array of themes.
                     */
                    $prepared_themes = apply_filters( 'wp_prepare_themes_for_js', $prepared_themes );
                    $prepared_themes = array_values( $prepared_themes );
                    return array_filter( $prepared_themes );
                }
                
        }
        
        
?>