<?php
		ini_set('memory_limit', '-1');
    class Woo_Product_Content 
        {
            var $functions;
            var $woomd_network;
            
            var $split_regex    =   '/<\!--wood-(\d+)-->(.*?)(?=<!--wood|$)/is';
               
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;

                    
                    add_action( 'wp_insert_post_data',  array ( $this, 'wp_insert_post_data' ) , -1, 2 );
                    
                    //prepar the content when ebing outputted on front side
                    add_action( 'the_content',          array ( $this, 'the_content' ) , -1 );
                    
                    //prepare the content when being outputd to dashboard editor
                    add_action( 'post_edit_form_tag',   array ( $this, 'post_edit_form_tag' ) , -1 );
                    
                }
                
            
            /**
            * Pack the content in required format
            *     
            * @param mixed $data
            * @param mixed $postarr
            */
            function wp_insert_post_data( $data, $postarr )
                {
                        
                    if ( $data['post_type'] !=  'product' ) 
                        return $data;
                    
                    global $blog_id, $wpdb;
                    
                    //get raw post data   
                    if ( isset ( $postarr['ID'] )   &&  $postarr['ID']  >   0 )
                        {
                            $post_ID    =   $postarr['ID'];
                            
                            $post_raw_data  =   $wpdb->get_row( "SELECT * FROM " . $wpdb->posts . " WHERE ID = " . $post_ID );
                            
                            if  ( $this->content_use_parts( $post_raw_data->post_content )    === FALSE )
                                {
                                    $data['post_content']   =   '<!--wood-' . $blog_id  .   '-->'  .   $data['post_content'];
                                    
                                    return $data;
                                }
                                
                            //the content already using parts
                            $data['post_content']    =   $this->content_update_part( $data['post_content'], $post_raw_data->post_content, $blog_id );
                            
                        }
                        else
                        {
                            $data['post_content']   =   '<!--wood-' . $blog_id  .   '-->'  .   $data['post_content'];   
                            return $data;
                            
                        }
                    
                    return $data;
                    
                }
            
            /**
            * Check if the content include parts
            * 
            * @param mixed $product_content
            */
            function content_use_parts( $product_content )
                {
                    
                    if  ( preg_match( $this->split_regex, $product_content) )
                        return TRUE;
                        else
                        return FALSE;
                
                }
                
                
                
            /**
            * Update the product content
            * 
            * @param mixed $product_content
            * @param mixed $raw_product_content
            * @param mixed $blog_id
            */
            function content_update_part( $product_content, $raw_product_content, $blog_id )
                {
                    
                    $results    =   preg_match_all( $this->split_regex, $raw_product_content, $matches);
                    
                    $found_part =   FALSE;
                    foreach  ( $matches[1]  as  $key    =>  $content_blog_id ) 
                        {
                            if  ( $content_blog_id  ==  $blog_id )
                                {
                                    $found_part =   TRUE;
                                    
                                    $matches[2][ $key ] =   $product_content;
                                    
                                    break;
                                }
                        }
                        
                    if  ( $found_part   === FALSE )
                        {
                            $matches[0][]   =   '';
                            $matches[1][]   =   $blog_id;
                            $matches[2][]   =   $product_content;
                        }
                        
                    $product_content    =   '';
                    foreach (   $matches[1]    as  $key    =>  $content_blog_id )
                        {
                            $product_content    .=  '<!--wood-' .  $content_blog_id  .   '-->'  .   $matches[2][$key];
                        }
                    
                    return $product_content;   
                }
                    
                
            function the_content( $product_content )
                {
                    global $blog_id;
                    
                    $product_content    =   $this->get_content_parts( $product_content, $blog_id );
                    
                    return $product_content;
                    
                }
                
                
            
            function post_edit_form_tag( $post )
                {
                    if ( $post->post_type   !=  'product' ) 
                        return;
                        
                    global $post, $blog_id;
                    
                    $product_content    =   $this->get_content_parts( $post->post_content, $blog_id );
                    
                    $post->post_content =   $product_content;
                    
                }
                
            
            
            /**
            * Split the content and return the found parts
            *     
            * @param mixed $content
            */
            function get_content_parts ( $product_content, $return_for_blog_id )
                {
                    
                    $results    =   preg_match_all( $this->split_regex, $product_content, $matches);
                    
                    if ( $results   === FALSE )
                        return $product_content;
                    
                    if  ( !isset($matches[0])    ||   ! is_array( $matches[0] )    ||  count ( $matches[0] ) < 1   )
                        return $product_content;   
                    
                    foreach  ( $matches[1]  as  $key    =>  $content_blog_id ) 
                        {
                            if  ( $content_blog_id  ==  $return_for_blog_id )
                                return $matches[2][ $key ];
                        }
                    
                    //not found, return default, which is the domain where the product has been created
                    reset ( $matches[2] );
                    
                    return current ( $matches[2] );
                }
          
         
        }

    new Woo_Product_Content();

?>