<?php

    class Woo_MultiDomain_Template 
        {
            var $functions;
            var $woomd_network;
            
            function __construct()
                {

                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;

                    
                    add_filter('woocommerce_get_checkout_url',                  array( $this,   'woocommerce_get_checkout_url'),  999);
                    
                                   
                    add_filter('woocommerce_order_item_permalink',              array( $this,   'woocommerce_order_item_permalink'),  999, 3);
                                        
                    add_filter('woocommerce_cart_item_thumbnail',               array( $this,   'on__woocommerce_cart_item_thumbnail'), 999, 3);
                    add_filter('woocommerce_cart_item_permalink',               array( $this,   'on__woocommerce_cart_item_permalink'), 999, 3);
                    
                    
                    //++++++++
                    //To keep or not?!
                    /*
                    add_filter('woocommerce_product_get_price' ,                array( $this,   'on__woocommerce_get_price'), 10, 2);
                    add_filter('woocommerce_product_get_regular' ,              array( $this,   'on__woocommerce_get_regular_price'), 10, 2);
                    add_filter('woocommerce_product_get_sale_price' ,           array( $this,   'on__woocommerce_get_sale_price'), 10, 2);
                    */                  
                }
                
            
            
            
            /**
            * Return Checkout url deppending on use selection
            *     
            * @param mixed $checkout_url
            */
            function woocommerce_get_checkout_url( $checkout_url )
                {
                    
                    global $blog_id, $woocommerce;
                     
                    $options    =   $this->functions->get_options();
                    
                    if( $options['cart_checkout_type']  ==  'single_checkout'  &&   ! empty($options['cart_checkout_location'])   &&  $options['cart_checkout_location']  !=  $blog_id    )
                        {
                            $this->woomd_network->switch_to_domain( $options['cart_checkout_location'] );
                            
                            $checkout_url = wc_get_page_permalink( 'checkout' );
                            if ( $checkout_url ) 
                                {
                                    // Force SSL if needed
                                    if ( is_ssl() || 'yes' === get_option( 'woocommerce_force_ssl_checkout' ) ) 
                                        {
                                            $checkout_url = str_replace( 'http:', 'https:', $checkout_url );
                                        }
                                }
                                
                            $this->woomd_network->restore_current_domain();
                            
                            $checkout_url   =   apply_filters( 'woomd/get_checkout_url',     $checkout_url);
                        }
                        else if ( $options['cart_checkout_type']  ==  'each_store' )
                            {
                                $checkout_url   =   $woocommerce->cart->cart_split->get_checkout_url();      
                            }
                    
                    return $checkout_url;    
                    
                }
                       
            
            /**
            * Return order item permalink
            * 
            * @param mixed $link
            * @param mixed $item
            * @param mixed $order
            */
            function woocommerce_order_item_permalink( $permalink, $item, $order)
                {
                    //only if multisite set
                    if( !isset($item['blog_id']))
                        return $permalink;    
                    
                    $this->woomd_network->switch_to_domain( $item['blog_id'] );
                    
                    $permalink  =   get_permalink( $item['product_id'] );
                    
                    $this->woomd_network->restore_current_domain();
                    
                    return $permalink;
                        
                }
                
                
                
            /**
            * Return the order item product thumbnail
            * 
            * @param mixed $image
            * @param mixed $cart_item
            * @param mixed $cart_item_key
            */
            function on__woocommerce_cart_item_thumbnail( $image, $cart_item, $cart_item_key )
                {
                    
                    //only if multisite set
                    if( !isset($cart_item['blog_id']))
                        return $image;
                    
                    $this->woomd_network->switch_to_domain( $cart_item['blog_id'] );
                    
                    $product    =   $cart_item['data'];   
                    $image      =   $product->get_image();
                    
                    $this->woomd_network->restore_current_domain();
                    
                    return $image;
                     
                    
                }
            
            
            
            /**
            * Return cart item permalink
            * 
            * @param mixed $permalink
            * @param mixed $cart_item
            * @param mixed $cart_item_key
            */
            function on__woocommerce_cart_item_permalink( $permalink, $cart_item, $cart_item_key )
                {
                    
                    //only if multisite set
                    if( !isset($cart_item['blog_id']))
                        return $permalink;
                    
                    $this->woomd_network->switch_to_domain( $cart_item['blog_id'] );
                    
                    $product        =   $cart_item['data'];
                    
                    //reset visibility
                    unset($product->visibility);
                       
                    $permalink      =   $product->is_visible() ? $product->get_permalink( $cart_item ) : '';
                    
                    $this->woomd_network->restore_current_domain();
                    
                    return $permalink;   
                    
                }
            
          
                 
        }

    new Woo_MultiDomain_Template();

?>